#include <inttypes.h>
#ifdef __AVR__
#include <avr/pgmspace.h>
#elif defined (ESP8266)
#include <pgmspace.h>
#else
#define PROGMEM
#endif

#ifndef BERNARD16_H
#define BERNARD16_H

#define BERNARD16_WIDTH 10
#define BERNARD16_HEIGHT 16

const static uint8_t Bernard16[] PROGMEM = {
    0x28, 0x46, // size
    0x0A, // width
    0x10, // height
    0x20, // first char
    0x60, // char count
    
    // char widths
    0x00, 0x03, 0x06, 0x09, 0x07, 0x0A, 0x08, 0x02, 0x05, 0x05, 
    0x06, 0x09, 0x03, 0x05, 0x03, 0x08, 0x07, 0x05, 0x07, 0x07, 
    0x08, 0x07, 0x07, 0x07, 0x07, 0x07, 0x03, 0x03, 0x09, 0x09, 
    0x09, 0x07, 0x0E, 0x08, 0x08, 0x05, 0x08, 0x07, 0x07, 0x08, 
    0x09, 0x05, 0x05, 0x09, 0x07, 0x09, 0x07, 0x07, 0x08, 0x07, 
    0x09, 0x06, 0x07, 0x07, 0x08, 0x0B, 0x08, 0x08, 0x06, 0x03, 
    0x08, 0x03, 0x06, 0x08, 0x03, 0x08, 0x07, 0x05, 0x08, 0x06, 
    0x04, 0x07, 0x08, 0x04, 0x03, 0x08, 0x04, 0x0C, 0x08, 0x07, 
    0x07, 0x08, 0x05, 0x04, 0x04, 0x08, 0x07, 0x0A, 0x07, 0x07, 
    0x05, 0x05, 0x02, 0x06, 0x09, 0x08, 
    
    // font data
    0x3E, 0xFE, 0x3E, 0x38, 0x3B, 0x38, // 33
    0x1E, 0x1E, 0x00, 0x00, 0x1E, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 34
    0x20, 0x20, 0xE0, 0x3E, 0x20, 0x20, 0xE0, 0x3E, 0x20, 0x04, 0x3C, 0x07, 0x04, 0x04, 0x3C, 0x07, 0x04, 0x04, // 35
    0x78, 0xFC, 0xE4, 0xFE, 0x8C, 0x9C, 0x18, 0x1C, 0x38, 0x31, 0x7F, 0x23, 0x3F, 0x1E, // 36
    0x7C, 0xFE, 0x82, 0xFE, 0xFC, 0x60, 0x9C, 0x82, 0x80, 0x00, 0x00, 0x00, 0x20, 0x1C, 0x03, 0x1F, 0x3F, 0x20, 0x3F, 0x1F, // 37
    0x00, 0x80, 0x7C, 0xFE, 0xE2, 0x1E, 0x8C, 0x80, 0x0F, 0x3F, 0x3C, 0x33, 0x1F, 0x3F, 0x3B, 0x08, // 38
    0x1E, 0x1E, 0x00, 0x00, // 39
    0xC0, 0xF0, 0xFC, 0xFC, 0x06, 0x07, 0x1F, 0x7F, 0x7F, 0xC0, // 40
    0x06, 0xFC, 0xFC, 0xF0, 0xE0, 0xC0, 0x7F, 0x7F, 0x1F, 0x07, // 41
    0x48, 0x78, 0xFC, 0xFC, 0x78, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 42
    0x80, 0x80, 0x80, 0x80, 0xF8, 0xF8, 0x80, 0x80, 0x80, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x0F, 0x01, 0x01, 0x01, // 43
    0x00, 0x00, 0x00, 0x98, 0xF8, 0x38, // 44
    0x00, 0x80, 0x80, 0x80, 0x80, 0x02, 0x03, 0x03, 0x03, 0x00, // 45
    0x00, 0x00, 0x00, 0x38, 0x38, 0x38, // 46
    0x00, 0x00, 0x00, 0xC0, 0xF0, 0x3C, 0x0E, 0x02, 0x20, 0x38, 0x1E, 0x07, 0x01, 0x00, 0x00, 0x00, // 47
    0xF0, 0xFC, 0xFE, 0x02, 0xFE, 0xFC, 0xF0, 0x07, 0x1F, 0x3F, 0x20, 0x3F, 0x1F, 0x07, // 48
    0x10, 0xF8, 0xFC, 0xFE, 0x00, 0x20, 0x3F, 0x3F, 0x3F, 0x20, // 49
    0x38, 0x3C, 0x02, 0x82, 0xFE, 0xFC, 0x78, 0x38, 0x3C, 0x36, 0x33, 0x31, 0x30, 0x1C, // 50
    0x1C, 0x9E, 0x82, 0x82, 0xFE, 0x7C, 0x38, 0x1C, 0x3C, 0x20, 0x20, 0x3F, 0x1F, 0x0E, // 51
    0x00, 0x00, 0xC0, 0x20, 0xF0, 0xFC, 0xFE, 0x00, 0x06, 0x05, 0x04, 0x24, 0x3F, 0x3F, 0x3F, 0x24, // 52
    0x00, 0xFC, 0x26, 0x26, 0xE6, 0xC6, 0x80, 0x1C, 0x3C, 0x20, 0x20, 0x3F, 0x1F, 0x0F, // 53
    0xF0, 0xF8, 0xFC, 0x16, 0xF2, 0xF2, 0xC0, 0x0F, 0x1F, 0x3F, 0x20, 0x3F, 0x1F, 0x0F, // 54
    0x1E, 0x06, 0x06, 0xC6, 0xF6, 0x7E, 0x06, 0x00, 0x20, 0x3E, 0x3F, 0x3F, 0x20, 0x00, // 55
    0x38, 0x7C, 0xE2, 0xE2, 0xC2, 0xBE, 0x3C, 0x0E, 0x1F, 0x20, 0x21, 0x23, 0x1F, 0x0F, // 56
    0xF8, 0xFC, 0xFE, 0x02, 0xFE, 0xFC, 0xF8, 0x00, 0x23, 0x23, 0x32, 0x1F, 0x0F, 0x07, // 57
    0xE0, 0xE0, 0xE0, 0x38, 0x38, 0x38, // 58
    0xE0, 0xE0, 0xE0, 0x98, 0xF8, 0x38, // 59
    0x80, 0xC0, 0xC0, 0x60, 0x60, 0x30, 0x30, 0x30, 0x18, 0x00, 0x01, 0x01, 0x03, 0x03, 0x06, 0x06, 0x06, 0x0C, // 60
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, // 61
    0x18, 0x30, 0x30, 0x30, 0x60, 0x60, 0xC0, 0xC0, 0x80, 0x0C, 0x06, 0x06, 0x06, 0x03, 0x03, 0x01, 0x01, 0x00, // 62
    0x1C, 0x1E, 0x1E, 0xC2, 0xFE, 0x7C, 0x3C, 0x00, 0x00, 0x38, 0x3B, 0x38, 0x00, 0x00, // 63
    0xC0, 0x30, 0x08, 0x04, 0xC2, 0xE2, 0x22, 0x22, 0xE2, 0x62, 0x04, 0x0C, 0xF0, 0x00, 0x07, 0x18, 0x20, 0x47, 0x4F, 0x44, 0x44, 0x4F, 0x4F, 0x48, 0x44, 0x22, 0x11, 0x08, // 64
    0x00, 0x00, 0xF2, 0xFE, 0xFE, 0xFE, 0x00, 0x00, 0x20, 0x3C, 0x27, 0x04, 0x3F, 0x3F, 0x3F, 0x20, // 65
    0x02, 0xFE, 0xFE, 0xFE, 0x42, 0xFE, 0xBE, 0x1C, 0x20, 0x3F, 0x3F, 0x3F, 0x20, 0x3F, 0x1F, 0x0F, // 66
    0xF0, 0xFC, 0xFE, 0x02, 0x1E, 0x07, 0x1F, 0x3F, 0x20, 0x18, // 67
    0x02, 0xFE, 0xFE, 0xFE, 0x02, 0xFE, 0xFC, 0xF0, 0x20, 0x3F, 0x3F, 0x3F, 0x20, 0x3F, 0x1F, 0x07, // 68
    0x02, 0xFE, 0xFE, 0xFE, 0x82, 0xC2, 0x0E, 0x20, 0x3F, 0x3F, 0x3F, 0x20, 0x21, 0x38, // 69
    0x02, 0xFE, 0xFE, 0xFE, 0x42, 0xE2, 0x0E, 0x20, 0x3F, 0x3F, 0x3F, 0x20, 0x00, 0x00, // 70
    0xF0, 0xFC, 0xFE, 0x02, 0xC2, 0xCE, 0xD8, 0x40, 0x07, 0x1F, 0x3F, 0x20, 0x3F, 0x1F, 0x3F, 0x00, // 71
    0x02, 0xFE, 0xFE, 0xFE, 0x40, 0xFE, 0xFE, 0xFE, 0x02, 0x20, 0x3F, 0x3F, 0x3F, 0x00, 0x3F, 0x3F, 0x3F, 0x20, // 72
    0x02, 0xFE, 0xFE, 0xFE, 0x02, 0x20, 0x3F, 0x3F, 0x3F, 0x20, // 73
    0x02, 0xFE, 0xFE, 0xFE, 0x02, 0x80, 0xFF, 0x7F, 0x3F, 0x00, // 74
    0x02, 0xFE, 0xFE, 0xFE, 0xC0, 0xF0, 0xEE, 0x02, 0x00, 0x20, 0x3F, 0x3F, 0x3F, 0x01, 0x3F, 0x3F, 0x3E, 0x20, // 75
    0x02, 0xFE, 0xFE, 0xFE, 0x02, 0x00, 0x00, 0x20, 0x3F, 0x3F, 0x3F, 0x20, 0x20, 0x38, // 76
    0x02, 0xFE, 0x7E, 0xF8, 0xF0, 0xFE, 0xFE, 0xFE, 0x02, 0x20, 0x3F, 0x20, 0x07, 0x20, 0x3F, 0x3F, 0x3F, 0x20, // 77
    0x02, 0xFE, 0xFE, 0xF8, 0xC2, 0xFE, 0x02, 0x20, 0x3F, 0x20, 0x07, 0x1F, 0x3F, 0x00, // 78
    0xF0, 0xFC, 0xFE, 0x02, 0xFE, 0xFC, 0xF0, 0x07, 0x1F, 0x3F, 0x20, 0x3F, 0x1F, 0x07, // 79
    0x02, 0xFE, 0xFE, 0xFE, 0x02, 0xFE, 0xFC, 0xF8, 0x20, 0x3F, 0x3F, 0x3F, 0x22, 0x03, 0x01, 0x00, // 80
    0xF0, 0xFC, 0xFE, 0x02, 0xFE, 0xFC, 0xF0, 0x07, 0x1F, 0x3F, 0x28, 0x3F, 0x7F, 0xE7, // 81
    0x02, 0xFE, 0xFE, 0xFE, 0x82, 0xFE, 0xFC, 0x78, 0x00, 0x20, 0x3F, 0x3F, 0x3F, 0x00, 0x3F, 0x3F, 0x3E, 0x20, // 82
    0x3C, 0xFE, 0xF2, 0xE6, 0x9E, 0x1C, 0x1C, 0x38, 0x23, 0x27, 0x3F, 0x1E, // 83
    0x0E, 0x02, 0xFE, 0xFE, 0xFE, 0x02, 0x0E, 0x00, 0x20, 0x3F, 0x3F, 0x3F, 0x20, 0x00, // 84
    0x02, 0xFE, 0xFE, 0xFE, 0x00, 0xFE, 0x02, 0x00, 0x1F, 0x3F, 0x3F, 0x30, 0x1F, 0x00, // 85
    0x02, 0x3E, 0xFE, 0xFE, 0xC0, 0xC2, 0x3E, 0x02, 0x00, 0x00, 0x07, 0x3F, 0x3F, 0x03, 0x00, 0x00, // 86
    0x02, 0x3E, 0xFE, 0xFE, 0xE2, 0xFE, 0xFE, 0xFE, 0xC2, 0x3E, 0x02, 0x00, 0x00, 0x0F, 0x3F, 0x3F, 0x00, 0x3F, 0x3F, 0x0F, 0x00, 0x00, // 87
    0x02, 0x1E, 0xFE, 0xFE, 0xE0, 0x1A, 0x06, 0x02, 0x20, 0x30, 0x2E, 0x07, 0x3F, 0x3F, 0x38, 0x20, // 88
    0x02, 0x0E, 0x7E, 0xFE, 0xF0, 0xE0, 0x1E, 0x02, 0x00, 0x00, 0x20, 0x3F, 0x3F, 0x3F, 0x20, 0x00, // 89
    0x0E, 0x82, 0xFA, 0xFE, 0xFE, 0x06, 0x38, 0x3F, 0x3F, 0x2F, 0x20, 0x38, // 90
    0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, // 91
    0x02, 0x0E, 0x3C, 0xF0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x07, 0x1E, 0x38, 0x20, // 92
    0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, // 93
    0x40, 0x38, 0x0E, 0x0E, 0x38, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 94
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, // 95
    0x01, 0x01, 0x02, 0x00, 0x00, 0x00, // 96
    0x30, 0xB8, 0xB8, 0x48, 0xF8, 0xF8, 0xF0, 0x00, 0x1F, 0x3F, 0x3F, 0x20, 0x3F, 0x3F, 0x3F, 0x20, // 97
    0xFE, 0xFE, 0xFE, 0x08, 0xF8, 0xF0, 0xE0, 0x3F, 0x3F, 0x3F, 0x20, 0x3F, 0x1F, 0x0F, // 98
    0xE0, 0xF0, 0xF8, 0x08, 0x70, 0x0F, 0x1F, 0x3F, 0x20, 0x1C, // 99
    0xE0, 0xF0, 0xF8, 0x0A, 0xFE, 0xFE, 0xFE, 0x00, 0x0F, 0x1F, 0x3F, 0x20, 0x3F, 0x3F, 0x3F, 0x20, // 100
    0xE0, 0xF0, 0xF8, 0x88, 0xF8, 0xE0, 0x0F, 0x1F, 0x3F, 0x20, 0x20, 0x1C, // 101
    0xFC, 0xFA, 0xFA, 0x0A, 0x3F, 0x3F, 0x3F, 0x20, // 102
    0xE0, 0xF0, 0xF8, 0x08, 0xFA, 0xF6, 0xE0, 0xD9, 0xF7, 0xB7, 0xB4, 0xB7, 0xF3, 0x61, // 103
    0xFE, 0xFE, 0xFE, 0x08, 0xF8, 0xF8, 0xF0, 0x00, 0x3F, 0x3F, 0x3F, 0x00, 0x3F, 0x3F, 0x3F, 0x20, // 104
    0xFA, 0xFA, 0xFA, 0x00, 0x3F, 0x3F, 0x3F, 0x20, // 105
    0xFA, 0xFA, 0xFA, 0xFF, 0x7F, 0x3F, // 106
    0xFE, 0xFE, 0xFE, 0x80, 0xE8, 0xF8, 0x08, 0x00, 0x3F, 0x3F, 0x3F, 0x03, 0x3F, 0x3F, 0x3E, 0x20, // 107
    0xFE, 0xFE, 0xFE, 0x00, 0x3F, 0x3F, 0x3F, 0x20, // 108
    0xF8, 0xF8, 0xF8, 0x08, 0xF8, 0xF8, 0xF8, 0x08, 0xF8, 0xF8, 0xF0, 0x00, 0x3F, 0x3F, 0x3F, 0x00, 0x3F, 0x3F, 0x3F, 0x00, 0x3F, 0x3F, 0x3F, 0x20, // 109
    0xF8, 0xF8, 0xF8, 0x08, 0xF8, 0xF8, 0xF0, 0x00, 0x3F, 0x3F, 0x3F, 0x00, 0x3F, 0x3F, 0x3F, 0x20, // 110
    0xE0, 0xF0, 0xF8, 0x08, 0xF8, 0xF0, 0xE0, 0x0F, 0x1F, 0x3F, 0x20, 0x3F, 0x1F, 0x0F, // 111
    0xF8, 0xF8, 0xF8, 0x08, 0xF8, 0xF0, 0xE0, 0xFF, 0xFF, 0xFF, 0xA0, 0x3F, 0x1F, 0x0F, // 112
    0xE0, 0xF0, 0xF8, 0x08, 0xF8, 0xF0, 0xF8, 0x00, 0x1F, 0x3F, 0x3F, 0xA0, 0xFF, 0xFF, 0xFF, 0x80, // 113
    0xF8, 0xF8, 0xF8, 0x10, 0x38, 0x3F, 0x3F, 0x3F, 0x20, 0x00, // 114
    0xF0, 0xF8, 0xC8, 0x18, 0x30, 0x27, 0x3F, 0x1F, // 115
    0xF8, 0xFC, 0xFE, 0x08, 0x3F, 0x3F, 0x3F, 0x20, // 116
    0xF8, 0xF8, 0xF8, 0x00, 0xF8, 0xF8, 0xF8, 0x00, 0x1F, 0x3F, 0x3F, 0x20, 0x3F, 0x3F, 0x3F, 0x20, // 117
    0x38, 0xF8, 0xF8, 0xC0, 0x00, 0xF8, 0x08, 0x00, 0x03, 0x3F, 0x3F, 0x3F, 0x00, 0x00, // 118
    0x78, 0xF8, 0xF8, 0x88, 0xF8, 0xF8, 0xF8, 0x80, 0x78, 0x08, 0x00, 0x0F, 0x3F, 0x3F, 0x01, 0x3F, 0x3F, 0x0F, 0x00, 0x00, // 119
    0x38, 0xF8, 0xF8, 0xC0, 0x38, 0x08, 0x08, 0x30, 0x0D, 0x07, 0x3F, 0x3E, 0x38, 0x20, // 120
    0x78, 0xF8, 0xF8, 0x80, 0x80, 0x78, 0x08, 0xC0, 0x8F, 0xFF, 0x7F, 0x0F, 0x00, 0x00, // 121
    0x38, 0x08, 0xF8, 0xF8, 0x38, 0x30, 0x3F, 0x3F, 0x23, 0x38, // 122
    0x00, 0x80, 0xFC, 0xFE, 0x06, 0x01, 0x03, 0x7F, 0xFE, 0xC0, // 123
    0xFE, 0xFE, 0xFF, 0xFF, // 124
    0x06, 0x06, 0xFE, 0xFC, 0x80, 0x00, 0xC0, 0xC0, 0xFE, 0x7F, 0x03, 0x01, // 125
    0x80, 0xC0, 0xC0, 0xC0, 0x80, 0x80, 0x80, 0x80, 0xC0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, // 126
    0xF0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xF0, 0x3F, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3F // 127
    
};

#endif
